
#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples, 
#we welcome you to contact us at SampleCode@melissadata.com also please visit our 
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

use mdPhonePerlWrapper;

#Enter your License here or with the environmental variable
my $LICENSE = "DEMO";

#Set the path to the data files
my $FILELOC = "C:\\Program Files\\Melissa DATA\\DQT\\Data";

#.................................................................................

$globalPhoneObj = new mdPhonePerlWrapper::mdGlobalPhone();
$phoneObj = new mdPhonePerlWrapper::mdPhone();


# ********************** LICENSE STRINGS ***********************
#       To unlock the full functionality of Phone Object,      
#   please call a sales representative at 1-800-MELISSA ext. 3  
#           (1-800-635-4772 x3) for a license string.          
#        Without a valid license string, Phone Object will     
#              only verify Nevada phone numbers.               
#                 REPLACE "DEMO" with LICENSE STRING                    

#   SetLicenseString will also check for a valid license in the 
#   MDPHONE_LICENSE(Environment) variable. This allows you to  
#   modify the license without recompiling the project
# **************************************************************
        
# Set the License String 
$phoneObj->SetLicenseString($LICENSE);
$globalPhoneObj->SetLicenseString($LICENSE);

# ********************** DATA FILE PATH  ***********************
#  File location path is set to the default Data File location
#  Change this value if you installed the data files to a       
#  different folder.                                            
#  The Data Files Directory must contain the following files:   
#  mdAddr.dat, mdPhone.dat, mdPhone.idx, and ZIPNPA.txt
# **************************************************************

# Iniitialize Global Phone Object
my $globalInitResult = $globalPhoneObj->Initialize($FILELOC);
if($globalInitResult != 0)
{
	printf $globalPhoneObj->GetInitializeErrorString(), "\n";
	die "Cannot Initialize Global Phone Object";
}

#Iniitialize Phone Object
my $InitResult = $phoneObj->Initialize($FILELOC);
if ($InitResult != 0)
{
  printf $phoneObj->GetInitializeErrorString(), "\n";
  die "Cannot Initialize Phone Object"; 
}

#.................................................................................

# Get the Build number and DB Date

print "\n\n\n====================================================================\n";
print "                         Melissa Data Global Phone Obj \n";
print "        Global Phone Obj Build Number: ", $globalPhoneObj->GetBuildNumber(), "\n";
print "       Global Phone Obj Database Date: ", $globalPhoneObj->GetDatabaseDate(), "\n";
print "   Global Phone Obj Initialize Status: ", $globalPhoneObj->GetInitializeErrorString(), "\n";
print "                                 -------------\n";
print "/                         Melissa Data Phone Object\n";
print "               Phone Obj Build Number: ", $phoneObj->GetBuildNumber(), "\n";
print "              Phone Obj Database Date: ", $phoneObj->GetDatabaseDate(), "\n";
print "          Phone Obj Initialize Status: ", $phoneObj->GetInitializeErrorString(), "\n";
print "====================================================================\n\n";

#.................................................................................

#Determine whether to use the Global Phone Obj or Phone Obj
print "Test Global Phone Obj or Phone Obj? (Type 'G' for Global Phone and 'P' for Phone Obj): ";
$object = <>;
chomp($object);

#Declare a result string variable
$ResultsString = "";

#Global Phone Obj sample
if($object eq "G")
	{
		print "Enter Phone (ex 422304850): ";
		$globalPhone = <>;
		
		print "Enter Country (ex JPN): ";
		$globalCountryName = <>;
		
		print "Enter country of origin (ex USA): ";
		$globalCountryOfOrigin = <>;
		
		chomp($globalPhone);
		chomp($globalCountryName);
		chomp($globalCountryOfOrigin);
		
		#Call the Lookup function and pass in the correct parameters
		$globalPhoneObj->Lookup($globalPhone,$globalCountryName,$globalCountryOfOrigin);
		
		#Return the output fields
		$ResultsString = $globalPhoneObj->GetResults();
		
		print "               Phone Number: ", $globalPhoneObj->GetPhoneNumber(), "\n";
		print "		  International Prefix: ", $globalPhoneObj->GetInternationalPrefix(), "\n";
		print "              Nation Prefix: ", $globalPhoneObj->GetNationPrefix(), "\n";
		print "  National Destination Code: ", $globalPhoneObj->GetNationalDestinationCode(), "\n"; 
		print "             Locality(City): ", $globalPhoneObj->GetLocality(), "\n";
		print "Administrative Area (State): ", $globalPhoneObj->GetAdministrativeArea(), "\n";
		print "                    Country: ", $globalPhoneObj->GetCountry(), "\n";
		print "               Country Code: ", $globalPhoneObj->GetCountryCode(), "\n";
		print "                        DST: ", $globalPhoneObj->GetDST(), "\n";
		print "                   Language: ", $globalPhoneObj->GetLanguage(), "\n";
		print "                   Latitude: ", $globalPhoneObj->GetLatitude(), "\n";
		print "                  Longitude: ", $globalPhoneObj->GetLongitude(), "\n";
		print "          Subscriber Number: ", $globalPhoneObj->GetSubscriberNumber(), "\n";
		print "                        UTC: ", $globalPhoneObj->GetUTC(), "\n";
	}

#Phone Obj sample
else
{
	print "Enter Phone (ex 7028965154): ";
	$phone = <>;
	print "Enter Zip (ex 89119): ";
	$zip = <>;
	
	chomp($phone);
	chomp($zip);
	
	#Call the Lookup function and pass in the phone number and ZIP
	$phoneObj->Lookup($phone,$zip);
	
	#Return the output fields
	$ResultsString = $phoneObj->GetResults();
	
	print "     Area Code: ", $phoneObj->GetAreaCode(), "\n";
	print "        Prefix: ", $phoneObj->GetPrefix(), "\n";
	print "        Suffix: ", $phoneObj->GetSuffix(), "\n"; 
	print "          City: ", $phoneObj->GetCity(), "\n";
	print "         State: ", $phoneObj->GetState(), "\n";
	print "  Country Code: ", $phoneObj->GetCountryCode(), "\n";
	print "          Fips: ", $phoneObj->GetCountyFips(), "\n";
	print "        County: ", $phoneObj->GetCountyName(), "\n";
	print "     Time Zone: ", $phoneObj->GetTimeZone(), "\n";
	print "Time Zone Code: ", $phoneObj->GetTimeZoneCode(), "\n";
	print "           MSA: ", $phoneObj->GetMsa(), "\n";
	print "          PMSA: ", $phoneObj->GetPmsa(), "\n";

	$latitude = $phoneObj->GetLatitude();
	$longitude = $phoneObj->GetLongitude();
	print "\n";
	print "      Latitude: ", $latitude, "\n";
	print "     Longitude: ", $longitude, "\n\n";
	print "\n";
	print "==================================================\n";
	print " Compute Distance and Bearing to another location\n";
	print " Lat / Long of US Capital: 38.889722  -77.0075 \n";
	print "==================================================\n";
	print "     Distance : ", $phoneObj->ComputeDistance($latitude, $longitude, 38.889722, -77.0075). " miles\n";
	print "      Bearing : ", $phoneObj->ComputeBearing($latitude, $longitude, 38.889722, -77.0075). " degrees\n\n";

	
	if($zip != "")
	{
	  $phoneObj->CorrectAreaCode($phone,$zip);

	  
	  print "=================== Correct Area Code Result =================\n";
	  print "      Area Code: ", $phoneObj->GetAreaCode(), "\n";
	  print " New Area Code : ", $phoneObj->GetNewAreaCode(), "\n";
	  print "         Prefix: ", $phoneObj->GetPrefix(), "\n";
	  print "         Suffix: ", $phoneObj->GetSuffix(), "\n";
	  print "      Extension: ", $phoneObj->GetExtension(), "\n";
	  print "        Results: ", $phoneObj->GetResults(),"\n";
	}
}

#Print Results Codes and their descriptions
print "\nResults: ",$ResultsString,"\n";

	if ($ResultsString =~ m/PE/i)
			{
			  if ($ResultsString =~ m/PE01/i)
			  {
				 print "Errors: Area Code Not valid\n";
			  }
			  if ($ResultsString =~ m/PE02/i)
			  {
				 print "Errors: Blank Phone Number\n";
			  } 
			  if ($ResultsString =~ m/PE03/i)
			  {
				 print "Errors: Phone Number Not valid\n";
			  }  
			  if ($ResultsString =~ m/PE04/i)
			  {
				 print "Errors: Input has Multiple Matches\n";
			  }  
			  if ($ResultsString =~ m/PE05/i)
			  {
				 print "Errors: Phone Prefix Not Valid\n";
			  }  
			  if ($ResultsString =~ m/PE06/i)
			  {
				 print "Errors: Zip Code Not Valid\n";
			  }
			  if ($ResultsString =~ m/PE08/i)
			  {
				 print "Errors: No Country Inputted\n";
			  }
			  if ($ResultsString =~ m/PE09/i)
			  {
				 print "Errors: Subscriber number was found out of range\n";
			  }
			  if ($ResultsString =~ m/PE10/i)
			  {
				 print "Errors: Bad country input\n";
			  } 
			}
			 			
	if (($ResultsString =~ m/PS01/i) || ($ResultsString =~ m/PS02/i))
	  { 
		if ($ResultsString =~ m/PS01/i)
		{
		  print "Phone validated to: 10 digits\n";
		}
		elsif ($ResultsString =~ m/PS02/i)
		{ 
		  print "Phone validated to:  7 digits\n";
		}
		if ($ResultsString =~ m/PS04/i)
		{
			  print "     Phone number is outside demo range\n";
		}
		if ($ResultsString =~ m/PS05/i)
		{
			  print "     Database has expired. Please contact Melissa Data.\n";
		}
		if ($ResultsString =~ m/PS06/i)
		{
			  print "     Updated area code\n";
		}
		if ($ResultsString =~ m/PS07/i)
		{
			  print "     Exchange Type: Cellular\n";
		}
		elsif($ResultsString =~ m/PS08/i)
		{
			  print "     Exchange Type: Land Line\n";
		}
		elsif($ResultsString =~ m/PS09/i)
		{
			  print "     Exchange Type: Voip\n";
		}
		
		if ($ResultsString =~ m/PS10/i)
		{
			  print "        Phone Type: Residential\n";
		}      
		elsif ($ResultsString =~ m/PS11/i)
		{
			  print "        Phone Type: Business\n";
		}      
		elsif ($ResultsString =~ m/PS12/i)
		{
			  print "        Phone Type: Small/Home Office\n";
		}
		if ($ResultsString =~ m/PS13/i)
		{
			  print "     International toll-free number detected\n";
		}
		if ($ResultsString =~ m/PS14/i)
		{
			  print "     International with higher charge rates detected\n";
		}
	}		
	  
print "\n\n\n";


